﻿using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;
using CommonTools;
using System.ComponentModel;
using System.Data;

namespace PsgBase
{
    [Designer(typeof(System.Windows.Forms.Design.ControlDesigner))]
    public partial class psgTreeList : TreeListView
    {
        ContextMenu m_contextMenu = null;
        public string initial_value = string.Empty;
        string valueKey, fieldKey;
        string fieldID, parentID, fieldDisplay, fieldDisplayIntl;
        string fieldName = string.Empty;
        string servertablename = string.Empty;
        string childtablename = string.Empty;
        string childfieldID = string.Empty;
        private DataTable table;
        bool admin = false;
        private bool isList = false;
        private string typeFieldName;

        public string TypeFieldName
        {
            get { return typeFieldName; }
            set { typeFieldName = value; }
        }

        [Browsable(false)]
        public bool Admin
        {
            get { return admin; }
            set { admin = value; }
        }

        [Browsable(false)]
        public bool IsList
        {
            get { return isList; }
            set { isList = value; }
        }

        [Browsable(false)]
        public DataTable Table
        {
            get { return table; }
            set { table = value; }
        }

        [Category("PSG")]
        public string PsgValueKey
        {
            get
            {

                if (this.FocusedNode == null || this.FocusedNode[this.PsgFieldKey] == null)
                    return string.Empty;
                else
                    return this.FocusedNode[this.PsgFieldKey].ToString();
            }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldDisplay
        {
            get { return fieldDisplay; }
            set { fieldDisplay = value; }
        }

        [Category("PSG")]
        public string PsgFieldDisplayIntl
        {
            get { return fieldDisplayIntl; }
            set { fieldDisplayIntl = value; }
        }

        [Category("PSG")]
        public string PsgFieldID
        {
            get { return fieldID; }
            set { fieldID = value; }
        }

        [Category("PSG")]
        public string PsgParentID
        {
            get { return parentID; }
            set { parentID = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        [Category("PSG")]
        public string PsgChildTableName
        {
            get { return childtablename; }
            set { childtablename = value; }
        }

        [Category("PSG")]
        public string PsgChildFieldID
        {
            get { return childfieldID; }
            set { childfieldID = value; }
        }

        private void SetCurrentPrimKey()
        {
            //if (this.Intf == null)
            //    return;

            //if (this.node)
            //{
            //    string _id = Convert.ToString((this.CurrentRow.Cells[this.PsgFieldKey].Value));
            //    this.Intf.SetCurrentPrimKey(this.PsgServerTableName, _id);
            //}
        }

        public psgTreeList()
        {
            m_contextMenu = new ContextMenu();
            m_contextMenu.MenuItems.Add(new MenuItem("Collapse All Children", new EventHandler(OnCollapseAllChildren)));
            m_contextMenu.MenuItems.Add(new MenuItem("Expand All Children", new EventHandler(OnExpandAllChildren)));
            m_contextMenu.MenuItems.Add(new MenuItem("Delete Selected Node", new EventHandler(OnDeleteSelectedNode)));

            InitializeComponent();
        }

        public void ExpandAllNodes()
        {
            foreach (Node node in this.Nodes)
                this.ExpandAllNodes(node);
        }

        public void ExpandAllNodes(Node parent)
        {
            foreach (Node node in parent.Nodes)
            {
                if (node.Nodes.Count > 0)
                    this.ExpandAllNodes();
                else
                    node.MakeVisible();
            }
        }

        public void ColapseAllNodes()
        {
            foreach (Node node in this.Nodes)
                this.ColapseAllNodes(node);
        }

        public void ColapseAllNodes(Node parent)
        {
            foreach (Node node in parent.Nodes)
            {
                if (node.Nodes.Count > 0)
                    this.ColapseAllNodes();
                else
                    node.Collapse();
            }
        }

        void OnCollapseAllChildren(object sender, EventArgs e)
        {
            BeginUpdate();
            if (MultiSelect && NodesSelection.Count > 0)
            {
                foreach (CommonTools.Node selnode in NodesSelection)
                {
                    foreach (CommonTools.Node node in selnode.Nodes)
                        node.Collapse();
                }
                NodesSelection.Clear();
            }
            if (FocusedNode != null && FocusedNode.HasChildren)
            {
                foreach (CommonTools.Node node in FocusedNode.Nodes)
                    node.Collapse();
            }
            EndUpdate();
        }

        void OnExpandAllChildren(object sender, EventArgs e)
        {
            BeginUpdate();
            if (MultiSelect && NodesSelection.Count > 0)
            {
                foreach (CommonTools.Node selnode in NodesSelection)
                    selnode.ExpandAll();
                NodesSelection.Clear();
            }
            if (FocusedNode != null)
                FocusedNode.ExpandAll();
            EndUpdate();
        }

        void OnDeleteSelectedNode(object sender, EventArgs e)
        {
            BeginUpdate();
            CommonTools.Node node = FocusedNode;
            if (node != null && node.Owner != null)
            {
                node.Collapse();
                CommonTools.Node nextnode = CommonTools.NodeCollection.GetNextNode(node, 1);
                if (nextnode == null)
                    nextnode = CommonTools.NodeCollection.GetNextNode(node, -1);
                node.Owner.Remove(node);
                FocusedNode = nextnode;
            }
            EndUpdate();
        }

        protected override void BeforeShowContextMenu()
        {
            if (GetHitNode() == null)
                ContextMenu = null;
            //else
                //???ContextMenu = m_contextMenu;
        }

        protected override object GetData(CommonTools.Node node, CommonTools.TreeListColumn column)
        {
            object data = base.GetData(node, column);
            if (data != null)
                return data;

            if (column.Fieldname == "childCount")
            {
                if (node.HasChildren)
                    return node.Nodes.Count;
                return "<none>";
            }
            if (column.Fieldname == "visibleCount")
            {
                if (node.HasChildren)
                    return node.VisibleNodeCount;
                return "<none>";
            }
            return string.Empty;
        }

        private string LabelIntl(TreeListColumn col)
        {
            if (this.DesignMode)
                return col.Caption;

            if (Base.tableIntl == null || Base.tableIntl.Rows.Count == 0)
                return col.Caption;

            return Base.GetIntl(col.PsgIntl, col.Caption);
        }

        public void PsgTreeListIntl(psgTreeList tl)
        {
            foreach (TreeListColumn col in tl.Columns)
            {
                col.Caption = LabelIntl(col);
                col.Caption = Utils.ToUpperFirstLetter(col.Caption);
                col.Caption = col.Caption.Replace('_', ' ');
                //col.Width = Math.Max(col.Width, col.HeaderText.Length * 8);

                //if (col.HeaderText.Substring(col.HeaderText.Length - 2, 2).ToLower() == "id")
                //    col.Visible = false;
                //if (col.HeaderText.Substring(col.HeaderText.Length - 1, 1).ToLower() == "_")
                //    col.Visible = false;
            }
        }

        public void DeleteNodes(DataTable dt, List<string> listIDs, string columnSort)
        {
            if (listIDs.Count == 0)
                return;

            Base.psgCommands.Clear();

            for (int i = 0; i < listIDs.Count; i++)
                this.DeleteNodeIntern(dt, listIDs[i], columnSort, true);            

            Intf.psgIntf.psgMultiCommand(ref Base.psgCommands);
            Base.psgCommands.Clear();
        }

        public void DeleteCurrentNode(DataTable dt, string columnSort)
        {
            if (!Utils.ConfirmDelete())
                return;

            if (this.FocusedNode == null)
                return;

            this.DeleteNodeIntern(dt, this.PsgValueKey, columnSort, false);
        }


        public void DeleteNode(DataTable dt, String nodeIDDelete, string columnSort)
        {
            if (!Utils.ConfirmDelete())
                return;

            this.DeleteNodeIntern(dt, nodeIDDelete, columnSort, false);
        }

        private void DeleteNodeIntern(DataTable dt, String nodeIDDelete, string columnSort, bool bMultiDelete)
        {
            if (dt == null || this == null)
                return;

            if (nodeIDDelete == null)
                return;

            if(!bMultiDelete)
                Base.psgCommands.Clear();

            List<string> ids = new List<string>();
            Intf.psgIntf.TreeListRemoveRows(this, nodeIDDelete, ref dt, ref ids);

            string id = string.Empty;
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                id = dt.Rows[i][this.PsgFieldID].ToString();
                if (ids.Contains(id))
                {
                    dt.Rows.Remove(dt.Rows[i]);
                    Base.psgCommands.Add(Intf.psgIntf.psgDelete(dt.TableName, id, this.PsgFieldKey, true));
                    i = i - 1;
                }
            }

            if (!bMultiDelete)
            {
                Intf.psgIntf.psgMultiCommand(ref Base.psgCommands);
                Base.psgCommands.Clear();
            }

            Node nod = Intf.psgIntf.FindNode(this, nodeIDDelete);
            Node parentNode = nod.Parent;

            if (parentNode != null)
            {
                if (nod.PrevSibling != null)
                    this.FocusedNode = nod.PrevSibling;
                else if (nod.NextSibling != null)
                    this.FocusedNode = nod.NextSibling;
                else
                    this.FocusedNode = parentNode;

                parentNode.Nodes.Remove(nod);
            }
            else
            {
                if (nod.PrevSibling != null)
                    this.FocusedNode = nod.PrevSibling;
                else if (nod.NextSibling != null)
                {
                    Intf.psgIntf.TreeListDataSource(this, dt, "", false, columnSort);

                    if (this.Nodes.Count > 0)
                        Intf.psgIntf.SelectNode(this, this.Nodes[0]);
                }
                else
                    this.Nodes.Clear();

                nod.Remove();
            }

            if (this.Nodes.Count == 0)
            {
                this.NodesSelection.Clear();
                this.FocusedNode = null;
                this.Nodes.Clear();
            }
        }

        private void psgTreeList_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (this.FocusedNode != null)
            {
                this.PsgValueKey = this.FocusedNode[this.PsgFieldKey].ToString();

                if (!string.IsNullOrEmpty(this.PsgServerTableName))
                    Base.psgIntf.SetCurrentPK(this.PsgServerTableName, this.PsgValueKey);
            }

            if (e.Node != null)
            {
                this.PsgValueKey = e.Node.Name;

                if (!string.IsNullOrEmpty(this.PsgServerTableName))
                    Base.psgIntf.SetCurrentPK(this.PsgServerTableName, e.Node.Name);
            }
        }
    }
}
